import { Group } from 'three';
import { ForwardRefComponent } from '../helpers/ts-utils';
export type OnCenterCallbackProps = {
    parent: THREE.Object3D;
    container: THREE.Object3D;
    width: number;
    height: number;
    depth: number;
    boundingBox: THREE.Box3;
    boundingSphere: THREE.Sphere;
    center: THREE.Vector3;
    verticalAlignment: number;
    horizontalAlignment: number;
    depthAlignment: number;
};
export type CenterProps = {
    top?: boolean;
    right?: boolean;
    bottom?: boolean;
    left?: boolean;
    front?: boolean;
    back?: boolean;
    disable?: boolean;
    disableX?: boolean;
    disableY?: boolean;
    disableZ?: boolean;
    precise?: boolean;
    onCentered?: (props: OnCenterCallbackProps) => void;
    cacheKey?: any;
};
export declare const Center: ForwardRefComponent<JSX.IntrinsicElements['group'] & CenterProps, Group>;
