"use strict";Object.defineProperty(exports,"__esModule",{value:!0});var e=require("@babel/runtime/helpers/extends"),t=require("react"),r=require("three"),o=require("@react-three/fiber"),i=require("./shaderMaterial.cjs.js"),n=require("../helpers/constants.cjs.js");function a(e){return e&&"object"==typeof e&&"default"in e?e:{default:e}}function s(e){if(e&&e.__esModule)return e;var t=Object.create(null);return e&&Object.keys(e).forEach((function(r){if("default"!==r){var o=Object.getOwnPropertyDescriptor(e,r);Object.defineProperty(t,r,o.get?o:{enumerable:!0,get:function(){return e[r]}})}})),t.default=e,Object.freeze(t)}var l=a(e),c=s(t),u=s(r);const f=i.shaderMaterial({time:0,pixelRatio:1}," uniform float pixelRatio;\n    uniform float time;\n    attribute float size;  \n    attribute float speed;  \n    attribute float opacity;\n    attribute vec3 noise;\n    attribute vec3 color;\n    varying vec3 vColor;\n    varying float vOpacity;\n    void main() {\n      vec4 modelPosition = modelMatrix * vec4(position, 1.0);\n      modelPosition.y += sin(time * speed + modelPosition.x * noise.x * 100.0) * 0.2;\n      modelPosition.z += cos(time * speed + modelPosition.x * noise.y * 100.0) * 0.2;\n      modelPosition.x += cos(time * speed + modelPosition.x * noise.z * 100.0) * 0.2;\n      vec4 viewPosition = viewMatrix * modelPosition;\n      vec4 projectionPostion = projectionMatrix * viewPosition;\n      gl_Position = projectionPostion;\n      gl_PointSize = size * 25. * pixelRatio;\n      gl_PointSize *= (1.0 / - viewPosition.z);\n      vColor = color;\n      vOpacity = opacity;\n    }",` varying vec3 vColor;\n    varying float vOpacity;\n    void main() {\n      float distanceToCenter = distance(gl_PointCoord, vec2(0.5));\n      float strength = 0.05 / distanceToCenter - 0.1;\n      gl_FragColor = vec4(vColor, strength * vOpacity);\n      #include <tonemapping_fragment>\n      #include <${n.version>=154?"colorspace_fragment":"encodings_fragment"}>\n    }`),m=e=>e&&e.constructor===Float32Array,p=e=>e instanceof u.Vector2||e instanceof u.Vector3||e instanceof u.Vector4,d=e=>Array.isArray(e)?e:p(e)?e.toArray():[e,e,e];function v(e,t,r){return c.useMemo((()=>{if(void 0!==t){if(m(t))return t;if(t instanceof u.Color){const r=Array.from({length:3*e},(()=>{return[(e=t).r,e.g,e.b];var e})).flat();return Float32Array.from(r)}if(p(t)||Array.isArray(t)){const r=Array.from({length:3*e},(()=>d(t))).flat();return Float32Array.from(r)}return Float32Array.from({length:e},(()=>t))}return Float32Array.from({length:e},r)}),[t])}const b=c.forwardRef((({noise:e=1,count:t=100,speed:r=1,opacity:i=1,scale:n=1,size:a,color:s,children:p,...b},y)=>{c.useMemo((()=>o.extend({SparklesImplMaterial:f})),[]);const g=c.useRef(null),h=o.useThree((e=>e.viewport.dpr)),A=d(n),P=c.useMemo((()=>Float32Array.from(Array.from({length:t},(()=>A.map(u.MathUtils.randFloatSpread))).flat())),[t,...A]),x=v(t,a,Math.random),j=v(t,i),M=v(t,r),O=v(3*t,e),_=v(void 0===s?3*t:t,m(s)?s:new u.Color(s),(()=>1));return o.useFrame((e=>{g.current&&g.current.material&&(g.current.material.time=e.clock.elapsedTime)})),c.useImperativeHandle(y,(()=>g.current),[]),c.createElement("points",l.default({key:`particle-${t}-${JSON.stringify(n)}`},b,{ref:g}),c.createElement("bufferGeometry",null,c.createElement("bufferAttribute",{attach:"attributes-position",args:[P,3]}),c.createElement("bufferAttribute",{attach:"attributes-size",args:[x,1]}),c.createElement("bufferAttribute",{attach:"attributes-opacity",args:[j,1]}),c.createElement("bufferAttribute",{attach:"attributes-speed",args:[M,1]}),c.createElement("bufferAttribute",{attach:"attributes-color",args:[_,3]}),c.createElement("bufferAttribute",{attach:"attributes-noise",args:[O,3]})),p||c.createElement("sparklesImplMaterial",{transparent:!0,pixelRatio:h,depthWrite:!1}))}));exports.Sparkles=b;
